/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MultipleBaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class DescriptorBaseUriParser {
    private static final String REST_SDK_BASE_URI = "http://a.ml/vocabularies/rest-sdk#baseUri";
    private static final String REST_SDK_BASE_URI_TYPE = "http://a.ml/vocabularies/rest-sdk#baseUriType";
    private static final String REST_SDK_MULTIPLE_BASE_URI = "http://a.ml/vocabularies/rest-sdk#multipleBaseUri";
    private static final String REST_SDK_DEFAULT_BASE_URI = "http://a.ml/vocabularies/rest-sdk#defaultBaseUri";
    private static final String API_CONTRACT_URL = "http://a.ml/vocabularies.rest.sdk/apiContract#url";

    public BaseUriDescriptor parseBaseUri(DialectDomainElement encodes) {
        DialectDomainElement baseUriElement = encodes.getObjectPropertyUri(REST_SDK_BASE_URI).stream().findFirst().orElse(null);
        if (baseUriElement == null) {
            return null;
        }
        return new BaseUriDescriptor(this.getUri(baseUriElement), this.getType(baseUriElement), this.getMultipleBaseUris(baseUriElement));
    }

    private String getType(@NotNull DialectDomainElement baseUriElement) {
        return DescriptorParserUtils.parseSingleStringProperty(baseUriElement, REST_SDK_BASE_URI_TYPE);
    }

    private String getUri(@NotNull DialectDomainElement baseUriElement) {
        return DescriptorParserUtils.parseSingleStringProperty(baseUriElement, API_CONTRACT_URL);
    }

    private List<MultipleBaseUriDescriptor> getMultipleBaseUris(@NotNull DialectDomainElement baseUriElement) {
        List multipleBaseUris = baseUriElement.getObjectPropertyUri(REST_SDK_MULTIPLE_BASE_URI);
        ArrayList<MultipleBaseUriDescriptor> multipleBaseUriDescriptorList = new ArrayList<MultipleBaseUriDescriptor>(multipleBaseUris.size());
        for (DialectDomainElement alternativeServerElement : multipleBaseUris) {
            String uriId = DescriptorParserUtils.parseCoreName(alternativeServerElement);
            String url = alternativeServerElement.getScalarByPropertyUri(API_CONTRACT_URL).get(0).toString();
            List defaults = alternativeServerElement.getScalarByPropertyUri(REST_SDK_DEFAULT_BASE_URI);
            boolean defaultUri = !defaults.isEmpty() && Boolean.parseBoolean(defaults.get(0).toString());
            MultipleBaseUriDescriptor multipleBaseUriDescriptor = new MultipleBaseUriDescriptor(uriId, url, defaultUri);
            multipleBaseUriDescriptorList.add(multipleBaseUriDescriptor);
        }
        return multipleBaseUriDescriptorList;
    }
}

