/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorOperationParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

class DescriptorEndpointParser {
    private static final String API_CONTRACT_ENDPOINT = "http://a.ml/vocabularies.rest.sdk/apiContract#endpoint";
    private final DescriptorOperationParser descriptorOperationParser = new DescriptorOperationParser();

    DescriptorEndpointParser() {
    }

    public List<EndPointDescriptor> parseEndpoints(DialectDomainElement encodes, Path descriptorFilePath) {
        ArrayList<EndPointDescriptor> endpointDescriptors = new ArrayList<EndPointDescriptor>();
        for (DialectDomainElement x : this.getEndpoints(encodes)) {
            endpointDescriptors.add(this.parseEndpoint(x, descriptorFilePath));
        }
        return endpointDescriptors;
    }

    private EndPointDescriptor parseEndpoint(DialectDomainElement endpointElement, Path descriptorFilePath) {
        return new EndPointDescriptor(DescriptorParserUtils.parseApiContractPath(endpointElement), this.descriptorOperationParser.parseOperations(endpointElement, descriptorFilePath), DescriptorParserUtils.parseNullableIgnore(endpointElement), DescriptorParserUtils.parseAlternativeBaseUri(endpointElement));
    }

    private List<DialectDomainElement> getEndpoints(DialectDomainElement encodes) {
        return encodes.getObjectPropertyUri(API_CONTRACT_ENDPOINT);
    }
}

