/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorApiSpecParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorBaseUriParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorEncodesParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorEndpointParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorMavenGavParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorPaginationParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorSecurityParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorTestConnectionParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorTriggerParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorValueResolverParser;
import com.mulesoft.connectivity.rest.sdk.internal.util.AMFWrapper;
import java.io.File;
import java.nio.file.Path;

public final class DescriptorParser {
    private static final DescriptorBaseUriParser baseUriParser = new DescriptorBaseUriParser();
    private static final DescriptorEndpointParser endpointParser = new DescriptorEndpointParser();
    private static final DescriptorApiSpecParser apiSpecParser = new DescriptorApiSpecParser();
    private static final DescriptorMavenGavParser mavenGavParser = new DescriptorMavenGavParser();
    private static final DescriptorEncodesParser encodesParser = new DescriptorEncodesParser();
    private static final DescriptorSecurityParser securityParser = new DescriptorSecurityParser();
    private static final DescriptorTestConnectionParser testConnectionParser = new DescriptorTestConnectionParser();
    private static final DescriptorTriggerParser triggerParser = new DescriptorTriggerParser();
    private static final DescriptorPaginationParser paginationParser = new DescriptorPaginationParser();
    private static final DescriptorValueResolverParser valueResolverParser = new DescriptorValueResolverParser();

    public ConnectorDescriptor parseConnectorDescriptor(File connectorDescriptor) throws ModelGenerationException {
        DialectDomainElement encodes = AMFWrapper.parseConnectorDescriptor(connectorDescriptor).encodes();
        Path descriptorPath = connectorDescriptor.toPath();
        return new ConnectorDescriptor(apiSpecParser.parseApiSpec(encodes), DescriptorParserUtils.parseCoreName(encodes), DescriptorParserUtils.parseCoreDescription(encodes), mavenGavParser.parseMavenGav(mavenGavParser.parseConnectorGavElement(encodes)), baseUriParser.parseBaseUri(encodes), endpointParser.parseEndpoints(encodes, descriptorPath), paginationParser.parsePaginationsDescription(encodes), securityParser.parseSecurityScheme(encodes), encodesParser.parseConnectorCategory(encodes), encodesParser.parseJavaPackage(encodes), encodesParser.parseExtensionXml(encodes), encodesParser.parseSkipOutputTypeValidation(encodes), encodesParser.parseDefaultInputMediaType(encodes), encodesParser.parseDefaultOutputMediaType(encodes), encodesParser.parseQueryParamArrayFormat(encodes), testConnectionParser.parseTestConnection(encodes), triggerParser.parseTriggers(encodes, descriptorPath), valueResolverParser.parseValueResolvers(encodes));
    }
}

