/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.HttpMethodDescriptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class DescriptorParserUtils {
    private static final String CORE_NAME = "http://a.ml/vocabularies.rest.sdk/core#name";
    private static final String CORE_DESCRIPTION = "http://a.ml/vocabularies.rest.sdk/core#description";
    private static final String REST_SDK_IGNORE = "http://a.ml/vocabularies/rest-sdk#ignore";
    private static final String REST_SDK_BASE_URI_REFERENCE = "http://a.ml/vocabularies/rest-sdk#baseUriReference";
    private static final String REST_SDK_FRIENDLY_NAME = "http://a.ml/vocabularies/rest-sdk#friendlyName";
    private static final String REST_SDK_REQUIRED = "http://a.ml/vocabularies/rest-sdk#required";
    private static final String API_CONTRACT_PATH = "http://a.ml/vocabularies.rest.sdk/apiContract#path";
    private static final String API_CONTRACT_METHOD = "http://a.ml/vocabularies.rest.sdk/apiContract#method";
    private static final String API_CONTRACT_PARAM_NAME = "http://a.ml/vocabularies.rest.sdk/apiContract#paramName";
    private static final String AML_REST_SDK_PARAMETER_TYPE = "http://a.ml/vocabularies/rest-sdk#parameterType";
    private static final String REST_SDK_DEFAULT_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/rest-sdk#inputMediaType";
    private static final String REST_SDK_DEFAULT_OUTPUT_MEDIA_TYPE = "http://a.ml/vocabularies/rest-sdk#outputMediaType";
    private static final String REST_SDK_INPUT_TYPE = "http://a.ml/vocabularies/rest-sdk#inputType";
    private static final String REST_SDK_OUTPUT_TYPE = "http://a.ml/vocabularies/rest-sdk#outputType";

    private DescriptorParserUtils() {
    }

    public static Boolean parseNullableIgnore(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleBooleanOrNullProperty(element, REST_SDK_IGNORE);
    }

    public static Boolean parseIgnore(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleBooleanProperty(element, REST_SDK_IGNORE);
    }

    public static boolean parseRequired(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleBooleanProperty(element, REST_SDK_REQUIRED);
    }

    public static String parseAlternativeBaseUri(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, REST_SDK_BASE_URI_REFERENCE);
    }

    public static String parseApiContractParamName(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, API_CONTRACT_PARAM_NAME);
    }

    public static String parseCoreName(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, CORE_NAME);
    }

    public static String parseCoreDescription(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, CORE_DESCRIPTION);
    }

    public static String parseFriendlyName(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, REST_SDK_FRIENDLY_NAME);
    }

    public static String parseApiContractPath(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, API_CONTRACT_PATH);
    }

    public static String parseApiContractMethod(DialectDomainElement element) {
        return DescriptorParserUtils.parseSingleStringProperty(element, API_CONTRACT_METHOD);
    }

    public static HttpMethodDescriptor parseApiContractMethodAsMethodDescriptor(DialectDomainElement element) {
        return HttpMethodDescriptor.forName(DescriptorParserUtils.parseApiContractMethod(element));
    }

    public static DataTypeDescriptor parseParameterType(DialectDomainElement parameterDescriptor) {
        return DataTypeDescriptor.forName(DescriptorParserUtils.parseSingleStringProperty(parameterDescriptor, AML_REST_SDK_PARAMETER_TYPE));
    }

    public static String parseSingleStringProperty(DialectDomainElement element, String propertyFQN) {
        List propertyInstances = element.getScalarByPropertyUri(propertyFQN);
        return propertyInstances.isEmpty() ? null : propertyInstances.get(0).toString();
    }

    public static boolean parseSingleBooleanProperty(DialectDomainElement element, String propertyFQN) {
        List propertyInstances = element.getScalarByPropertyUri(propertyFQN);
        return !propertyInstances.isEmpty() && Boolean.parseBoolean(propertyInstances.get(0).toString());
    }

    public static Boolean parseSingleBooleanOrNullProperty(DialectDomainElement element, String propertyFQN) {
        List propertyInstances = element.getScalarByPropertyUri(propertyFQN);
        return propertyInstances.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(propertyInstances.get(0).toString()));
    }

    public static DialectDomainElement getSingleObjectProperty(DialectDomainElement element, String propertyFQN) {
        List propertyInstances = element.getObjectPropertyUri(propertyFQN);
        return propertyInstances.isEmpty() ? null : (DialectDomainElement)propertyInstances.get(0);
    }

    public static String parseInputMediaType(DialectDomainElement parentElement) {
        return DescriptorParserUtils.parseSingleStringProperty(parentElement, REST_SDK_DEFAULT_INPUT_MEDIA_TYPE);
    }

    public static String parseOutputMediaType(DialectDomainElement parentElement) {
        return DescriptorParserUtils.parseSingleStringProperty(parentElement, REST_SDK_DEFAULT_OUTPUT_MEDIA_TYPE);
    }

    public static String parseInputTypeSchema(DialectDomainElement parentElement, Path descriptorDirectory) {
        String inputSchemaPath = DescriptorParserUtils.parseSingleStringProperty(parentElement, REST_SDK_INPUT_TYPE);
        return DescriptorParserUtils.getSchemaContent(descriptorDirectory, inputSchemaPath);
    }

    public static String parseOutputTypeSchema(DialectDomainElement parentElement, Path descriptorDirectory) {
        String outputSchemaPath = DescriptorParserUtils.parseSingleStringProperty(parentElement, REST_SDK_OUTPUT_TYPE);
        return DescriptorParserUtils.getSchemaContent(descriptorDirectory, outputSchemaPath);
    }

    private static String getSchemaContent(Path descriptorDirectory, String inputSchemaPathString) {
        if (StringUtils.isBlank((CharSequence)inputSchemaPathString)) {
            return null;
        }
        Path schemaPath = descriptorDirectory.resolve(inputSchemaPathString);
        try {
            byte[] encoded = Files.readAllBytes(schemaPath);
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read schema file: " + schemaPath, e);
        }
    }
}

