/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class DescriptorPartParser {
    private static final String REST_SDK_FRIENDLY_NAME = "http://a.ml/vocabularies/rest-sdk#friendlyName";
    private static final String REST_SDK_FILE_PART = "http://a.ml/vocabularies/rest-sdk#filePart";

    public List<PartDescriptor> parseParts(List<DialectDomainElement> parameterElements, Path descriptorFilePath) {
        ArrayList<PartDescriptor> parts = new ArrayList<PartDescriptor>();
        for (DialectDomainElement p : parameterElements) {
            parts.add(this.parsePart(p, descriptorFilePath));
        }
        return parts;
    }

    private PartDescriptor parsePart(DialectDomainElement partElement, Path descriptorFilePath) {
        return new PartDescriptor(this.getPartName(partElement), this.getFriendlyName(partElement), this.getDescription(partElement), DescriptorParserUtils.parseInputTypeSchema(partElement, descriptorFilePath), DescriptorParserUtils.parseInputMediaType(partElement), this.getFilePart(partElement));
    }

    private String getPartName(DialectDomainElement partElement) {
        return DescriptorParserUtils.parseApiContractParamName(partElement);
    }

    private String getFriendlyName(DialectDomainElement partElement) {
        return DescriptorParserUtils.parseSingleStringProperty(partElement, REST_SDK_FRIENDLY_NAME);
    }

    private String getDescription(DialectDomainElement partElement) {
        return DescriptorParserUtils.parseCoreDescription(partElement);
    }

    private boolean getFilePart(DialectDomainElement partElement) {
        return DescriptorParserUtils.parseSingleBooleanProperty(partElement, REST_SDK_FILE_PART);
    }
}

