/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParameterParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorPartParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DescriptorRequestParser {
    private static final Map<String, String> AMF_PARAMETER_TYPE = ImmutableMap.builder().put((Object)ParameterType.URI.getName(), (Object)"uriParameter").put((Object)ParameterType.QUERY.getName(), (Object)"queryString").put((Object)ParameterType.HEADER.getName(), (Object)"header").build();
    private static final String API_CONTRACT_EXPECTS = "http://a.ml/vocabularies.rest.sdk/apiContract#expects";
    private static final String API_CONTRACT_PARAMETER_NAMES = "http://a.ml/vocabularies.rest.sdk/apiContract#%s";
    private static final String REST_SDK_PART = "http://a.ml/vocabularies/rest-sdk#part";
    private static final DescriptorParameterParser descriptorParameterParser = new DescriptorParameterParser();
    private static final DescriptorPartParser descriptorPartParser = new DescriptorPartParser();

    public RequestDescriptor parseRequest(DialectDomainElement operationElement, Path descriptorFilePath) {
        DialectDomainElement expectsElement = this.parseExpectsElement(operationElement);
        if (expectsElement == null) {
            return null;
        }
        return new RequestDescriptor(descriptorParameterParser.parseParameters(this.getParametersByType(expectsElement, ParameterType.HEADER)), descriptorParameterParser.parseParameters(this.getParametersByType(expectsElement, ParameterType.QUERY)), descriptorParameterParser.parseParameters(this.getParametersByType(expectsElement, ParameterType.URI)), descriptorPartParser.parseParts(this.getParts(expectsElement), descriptorFilePath));
    }

    private List<DialectDomainElement> getParametersByType(DialectDomainElement expects, ParameterType parameterType) {
        String amfParameterType = String.format(API_CONTRACT_PARAMETER_NAMES, AMF_PARAMETER_TYPE.get(parameterType.getName()));
        return new ArrayList<DialectDomainElement>(expects.getObjectPropertyUri(amfParameterType));
    }

    private List<DialectDomainElement> getParts(DialectDomainElement expects) {
        return new ArrayList<DialectDomainElement>(expects.getObjectPropertyUri(REST_SDK_PART));
    }

    private DialectDomainElement parseExpectsElement(DialectDomainElement operationElement) {
        return DescriptorParserUtils.getSingleObjectProperty(operationElement, API_CONTRACT_EXPECTS);
    }
}

