/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorValueResolverBindingParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorValueResolverItemsParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorValueResolverParametersParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DescriptorValueResolverParser {
    private static final String AML_REST_SDK_VALUE_RESOLVERS = "http://a.ml/vocabularies/rest-sdk#valueResolvers";
    private static final DescriptorValueResolverItemsParser valueResolverItemsParser = new DescriptorValueResolverItemsParser();
    private static final DescriptorValueResolverBindingParser valueResolverBindingParser = new DescriptorValueResolverBindingParser();
    private static final DescriptorValueResolverParametersParser valueResolverParametersParser = new DescriptorValueResolverParametersParser();

    public List<ValueResolverDescriptor> parseValueResolvers(DialectDomainElement encodes) {
        List valueResolvers = encodes.getObjectPropertyUri(AML_REST_SDK_VALUE_RESOLVERS);
        if (valueResolvers == null) {
            return Collections.emptyList();
        }
        LinkedList<ValueResolverDescriptor> result = new LinkedList<ValueResolverDescriptor>();
        for (DialectDomainElement valueResolver : valueResolvers) {
            result.add(this.parseValueResolver(valueResolver));
        }
        return result;
    }

    private ValueResolverDescriptor parseValueResolver(DialectDomainElement valueResolver) {
        return new ValueResolverDescriptor(DescriptorParserUtils.parseCoreName(valueResolver), DescriptorParserUtils.parseApiContractPath(valueResolver), DescriptorParserUtils.parseApiContractMethodAsMethodDescriptor(valueResolver), valueResolverItemsParser.parseItems(valueResolver), valueResolverParametersParser.parseParameters(valueResolver), valueResolverBindingParser.parseBinding(valueResolver));
    }
}

