/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.internal.util.FileGenerationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataFormat;

public abstract class SdkAbstractStaticMetadataResolver
extends JavaTemplateEntity {
    private final TypeDefinition typeDefinition;
    private static final String GET_SCHEMA_PATH_METHOD_NAME = "getSchemaPath";
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private static final String GET_QNAME_METHOD_NAME = "getQName";
    private static final String GET_FORMAT_METHOD_NAME = "getFormat";
    private final boolean requiresMetadataResolver;
    private final boolean requiresToWriteSchema;
    private static final String SCHEMAS_FOLDER = "schemas";
    private String schemaName;
    private String schemaPath;
    private String className;
    private String javaPackage;
    private String categoryName;
    protected Class<?> superclass;

    public SdkAbstractStaticMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, FileGenerationUtils.SchemaNameType schemaNameType, String partName, String classNameOverride, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.typeDefinition = typeDefinition;
        this.superclass = this.buildSuperclass(typeDefinition);
        this.requiresMetadataResolver = this.buildRequiresMetadataResolver();
        this.requiresToWriteSchema = this.requiresToWriteSchema();
        Path schemaOutputDir = sdkConnector.getResourcesPath().resolve(SCHEMAS_FOLDER);
        if (FileGenerationUtils.supportsSchemaGeneration(typeDefinition.getTypeSchema())) {
            this.schemaName = FileGenerationUtils.generateSchemaName(typeDefinition.getTypeSchema(), operation, schemaNameType, partName, schemaOutputDir, sdkConnector.getTypeSchemaNames());
            if (this.requiresMetadataResolver) {
                this.className = this.buildClassName(operation, partName, classNameOverride);
                this.javaPackage = this.buildPackage(connectorModel);
                this.categoryName = SdkAbstractStaticMetadataResolver.buildCategoryName(operation);
                if (this.requiresToWriteSchema) {
                    FileGenerationUtils.writeSchema(typeDefinition.getTypeSchema(), schemaOutputDir, this.schemaName);
                    this.schemaPath = "/schemas/" + this.schemaName;
                }
            }
        }
    }

    protected abstract Class<?> buildSuperclass(TypeDefinition var1) throws TemplatingException;

    protected abstract String getClassNameSuffix();

    private String buildClassName(ConnectorOperation operation, String partName, String classNameOverride) {
        if (StringUtils.isBlank((CharSequence)classNameOverride)) {
            return JavaUtils.getJavaUpperCamelNameFromXml(operation.getInternalName()) + (StringUtils.isNotBlank((CharSequence)partName) ? JavaUtils.getJavaUpperCamelNameFromXml(XmlUtils.getXmlName(partName)) : "") + this.getClassNameSuffix();
        }
        return JavaUtils.getJavaUpperCamelNameFromXml(XmlUtils.getXmlName(classNameOverride)) + this.getClassNameSuffix();
    }

    private static String buildCategoryName(ConnectorOperation operation) {
        return operation.getInternalName() + "-type-resolver";
    }

    private String buildPackage(ConnectorModel connectorModel) {
        return connectorModel.getBasePackage() + ".internal.metadata";
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackage() {
        return this.javaPackage;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.requiresMetadataResolver) {
            this.generateMetadataResolverClass();
        }
    }

    private void generateMetadataResolverClass() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass);
        if (this.requiresToWriteSchema) {
            this.addGetSchemaPathMethod(typeResolverClassBuilder);
        }
        if (this.requiresCategoryNameMethod()) {
            this.addGetCategoryNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresQNameMethod()) {
            this.addGetQNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresFormatMethod()) {
            this.addFormatMethod(typeResolverClassBuilder);
        }
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    private void addFormatMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return new $1T($2S, $2S, $2S)", new Object[]{MetadataFormat.class, this.typeDefinition.getMediaType().getType() + "/" + this.typeDefinition.getMediaType().getSubtype()}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_FORMAT_METHOD_NAME).returns(TypeName.get(MetadataFormat.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetSchemaPathMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.schemaPath}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_SCHEMA_PATH_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.categoryName}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void addGetQNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.getQName()}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_QNAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    protected boolean requiresCategoryNameMethod() {
        return true;
    }

    protected abstract boolean requiresQNameMethod();

    protected abstract boolean requiresFormatMethod();

    protected abstract String getQName();

    protected boolean buildRequiresMetadataResolver() {
        return !(this.typeDefinition instanceof EmptyTypeDefinition);
    }

    public boolean getRequiresMetadataResolver() {
        return this.requiresMetadataResolver;
    }

    protected abstract boolean requiresToWriteSchema();

    public String getSchemaName() {
        return this.schemaName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

