/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkOperationFactory;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkTrigger;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;

public class SdkConfig
extends JavaTemplateEntity {
    private final SdkConnector connector;
    private final List<SdkConnectionProvider> connectionProviders;
    private final List<AbstractSdkOperation> operations;
    private final List<SdkTrigger> triggers;

    public SdkConfig(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.connector = sdkConnector;
        this.connectionProviders = this.buildConnectionProviders(outputDir, connectorModel, sdkConnector);
        this.operations = new LinkedList<AbstractSdkOperation>();
        for (ConnectorOperation operation : connectorModel.getOperations()) {
            this.operations.add(SdkOperationFactory.create(outputDir, connectorModel, sdkConnector, operation, runConfiguration));
        }
        this.triggers = new LinkedList<SdkTrigger>();
        for (Trigger triggerModel : connectorModel.getTriggers()) {
            this.triggers.add(new SdkTrigger(outputDir, connectorModel, sdkConnector, triggerModel, runConfiguration));
        }
    }

    private List<SdkConnectionProvider> buildConnectionProviders(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector) throws TemplatingException {
        List securitySchemeModels = connectorModel.getOperations().stream().map(ConnectorOperation::getSecuritySchemes).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        ArrayList<SdkConnectionProvider> list = new ArrayList<SdkConnectionProvider>();
        for (ConnectorSecurityScheme scheme : securitySchemeModels) {
            list.add(new SdkConnectionProvider(outputDir, connectorModel, sdkConnector, scheme, this.runConfiguration));
        }
        return list;
    }

    public String getJavaClassName() {
        String baseName = this.connector.getJavaName().endsWith("Connector") ? this.connector.getJavaName().substring(0, this.connector.getJavaName().length() - 9) : this.connector.getJavaName();
        return baseName + "Configuration";
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.config";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConfigClass();
        for (SdkConnectionProvider connectionProvider : this.connectionProviders) {
            connectionProvider.applyTemplates();
        }
        for (AbstractSdkOperation operation : this.operations) {
            operation.applyTemplates();
        }
        for (SdkTrigger trigger : this.triggers) {
            trigger.applyTemplates();
        }
    }

    private void generateConfigClass() throws TemplatingException {
        TypeSpec.Builder configClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(RestConfiguration.class).addAnnotation(this.getConfigurationAnnotation()).addAnnotation(this.getOperationsAnnotation()).addAnnotation(this.getConnectionProvidersAnnotation());
        if (!this.triggers.isEmpty()) {
            configClassBuilder.addAnnotation(this.getSourcesAnnotation());
        }
        this.writeClassToFile(configClassBuilder.build(), this.getPackage());
    }

    private AnnotationSpec getSourcesAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.triggers.size(); ++i) {
            SdkTrigger trigger = this.triggers.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)trigger.getPackage(), (String)trigger.getJavaClassName(), (String[])new String[0])});
            if (i >= this.triggers.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder sourcesAnnotationBuilder = AnnotationSpec.builder(Sources.class).addMember("value", codeBlock.build());
        return sourcesAnnotationBuilder.build();
    }

    private AnnotationSpec getOperationsAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.operations.size(); ++i) {
            AbstractSdkOperation operation = this.operations.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)operation.getPackage(), (String)operation.getJavaClassName(), (String[])new String[0])});
            if (i >= this.operations.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder operationsAnnotationBuilder = AnnotationSpec.builder(Operations.class).addMember("value", codeBlock.build());
        return operationsAnnotationBuilder.build();
    }

    private AnnotationSpec getConnectionProvidersAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.connectionProviders.size(); ++i) {
            SdkConnectionProvider connectionProvider = this.connectionProviders.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)connectionProvider.getPackage(), (String)connectionProvider.getJavaClassName(), (String[])new String[0])});
            if (i >= this.connectionProviders.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder connectionProvidersAnnotationBuilder = AnnotationSpec.builder(ConnectionProviders.class).addMember("value", codeBlock.build());
        return connectionProvidersAnnotationBuilder.build();
    }

    private AnnotationSpec getConfigurationAnnotation() {
        AnnotationSpec.Builder extensionAnnotationBuilder = AnnotationSpec.builder(Configuration.class);
        return extensionAnnotationBuilder.build();
    }
}

