/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.data.sample.RestSampleDataProviderTrigger;
import com.mulesoft.connectivity.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkTrigger;
import com.mulesoft.connectivity.rest.sdk.internal.util.JavaUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.param.Parameter;

public class SdkSampleDataProviderTrigger
extends JavaTemplateEntity {
    private static final String GET_TYPED_VALUE_OR_NULL_METHOD = "getTypedValueOrNull";
    private static final String GET_PATH_TEMPLATE_METHOD = "getPathTemplate";
    private static final String GET_REQUEST_BUILDER_METHOD = "getRequestBuilder";
    private static final String GET_PARAMETER_BINDING_METHOD = "getParameterBinding";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "binding";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String GET_PARAMETER_VALUES_METHOD = "getParameterValues";
    private static final String PATH_TEMPLATE_FIELD = "PATH";
    private static final String ITEMS_EXPRESSION_FIELD = "ITEMS_EXPRESSION";
    private static final String PARAMETER_VALUES_LOCAL_VARIABLE = "parameterValues";
    private final Trigger trigger;
    private final ConnectorOperation operation;
    private final String javaClassName;
    private final String aPackage;

    public SdkSampleDataProviderTrigger(Path outputDir, ConnectorModel connectorModel, SdkTrigger sdkTrigger, Trigger trigger, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.trigger = trigger;
        this.operation = trigger.getOperation();
        this.javaClassName = sdkTrigger.getJavaClassName();
        this.aPackage = sdkTrigger.getPackage();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateValueProviderClass();
    }

    public String getPackage() {
        return this.aPackage + ".sample.data";
    }

    public String getJavaClassName() {
        return this.javaClassName + "SampleDataProvider";
    }

    private void generateValueProviderClass() throws TemplatingException {
        TypeSpec.Builder valueProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((Type)this.getSuperclass()).addMethod(this.generateConstructor()).addMethod(this.generateGetPathTemplateMethod()).addMethod(this.generateGetRequestBuilderMethod()).addMethod(this.generateGetParameterBindingMethod()).addMethod(this.generateGetParameterValuesMethod());
        this.addClassConstants(valueProviderClassBuilder);
        this.addParameters(valueProviderClassBuilder);
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(valueProviderClassBuilder.build(), this.getPackage());
        javaFileBuilder.addStaticImport(RestSdkUtils.class, new String[]{GET_TYPED_VALUE_OR_NULL_METHOD});
        this.writeJavaFile(javaFileBuilder.build());
    }

    private Class getSuperclass() {
        return RestSampleDataProviderTrigger.class;
    }

    private MethodSpec generateConstructor() {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addStatement("super($L)", new Object[]{ITEMS_EXPRESSION_FIELD});
        return constructorBuilder.build();
    }

    private MethodSpec generateGetPathTemplateMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PATH_TEMPLATE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $L", new Object[]{PATH_TEMPLATE_FIELD});
        return methodBuilder.build();
    }

    private MethodSpec generateGetRequestBuilderMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BUILDER_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RestRequestBuilder.class).addAnnotation(Override.class).addParameter(String.class, "path", new Modifier[0]);
        methodBuilder.addStatement("return new $T(connection.getBaseUri(), path, $T.$L)", new Object[]{RestRequestBuilder.class, HttpConstants.Method.class, this.operation.getHttpMethod().toUpperCase()});
        return methodBuilder.build();
    }

    private MethodSpec generateGetParameterBindingMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_BINDING_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RequestParameterBinding.class).addAnnotation(Override.class);
        methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{RequestParameterBinding.class, PARAMETER_BINDING_LOCAL_VARIABLE});
        if (this.trigger.getParameterBindings() != null) {
            for (ParameterBinding binding : this.trigger.getParameterBindings()) {
                methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, this.getParameterBindingAddMethodName(binding), binding.getName(), binding.getExpression()});
            }
        }
        methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private String getParameterBindingAddMethodName(ParameterBinding binding) {
        switch (binding.getParameterType()) {
            case QUERY: {
                return ADD_QUERY_BINDING_METHOD;
            }
            case HEADER: {
                return ADD_HEADER_BINDING_METHOD;
            }
            case URI: {
                return ADD_URI_BINDING_METHOD;
            }
        }
        throw new IllegalArgumentException("Parameter type not supported: " + (Object)((Object)binding.getParameterType()));
    }

    private MethodSpec generateGetParameterValuesMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_VALUES_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.getParameterValuesMultiMapType()).addAnnotation(Override.class);
        methodBuilder.addStatement("final $T $L = new $T<>()", new Object[]{this.getParameterValuesMultiMapType(), PARAMETER_VALUES_LOCAL_VARIABLE, MultiMap.class});
        for (TriggerParameter parameter : this.trigger.getParameters()) {
            methodBuilder.addStatement("$L.put($S, $L($L))", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE, parameter.getExternalName(), GET_TYPED_VALUE_OR_NULL_METHOD, JavaUtils.getJavaLowerCamelNameFromXml(parameter.getInternalName())});
        }
        methodBuilder.addStatement("return $L", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private ParameterizedTypeName getParameterValuesMultiMapType() {
        ParameterizedTypeName wildcardTypedValueType = ParameterizedTypeName.get((ClassName)ClassName.get(TypedValue.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        return ParameterizedTypeName.get((ClassName)ClassName.get(MultiMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), wildcardTypedValueType});
    }

    private void addClassConstants(TypeSpec.Builder valueProviderClassBuilder) {
        valueProviderClassBuilder.addField(this.getConstantStringField(PATH_TEMPLATE_FIELD, this.operation.getPath())).addField(this.getConstantStringField(ITEMS_EXPRESSION_FIELD, this.trigger.getItemsExpression()));
    }

    private void addParameters(TypeSpec.Builder triggerClassBuilder) {
        for (TriggerParameter parameter : this.trigger.getParameters()) {
            triggerClassBuilder.addField(this.getParameter(parameter));
        }
    }

    private FieldSpec getParameter(TriggerParameter parameter) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder(this.getJavaType(parameter.getParameterType()), (String)JavaUtils.getJavaLowerCamelNameFromXml(parameter.getInternalName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class);
        return fieldBuilder.build();
    }
}

