/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSource;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkSampleDataProviderTrigger;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkTriggerOutputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.util.JavaUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class SdkTrigger
extends JavaTemplateEntity {
    private static final String PATH_TEMPLATE_FIELD = "PATH_TEMPLATE";
    private static final String ITEMS_EXPRESSION_FIELD = "ITEMS_EXPRESSION";
    private static final String WATERMARK_EXPRESSION_FIELD = "WATERMARK_EXPRESSION";
    private static final String IDENTITY_EXPRESSION_FIELD = "IDENTITY_EXPRESSION";
    private static final String REQUEST_BODY_EXPRESSION_FIELD = "REQUEST_BODY_EXPRESSION";
    private static final String WATERMARK_DATA_TYPE_METHOD = "getWatermarkDataType";
    private static final String GET_PATH_TEMPLATE_METHOD = "getPathTemplate";
    private static final String GET_REQUEST_BUILDER_METHOD = "getRequestBuilder";
    private static final String GET_PARAMETER_BINDING_METHOD = "getParameterBinding";
    private static final String GET_PARAMETER_VALUES_METHOD = "getParameterValues";
    private static final String GET_REQUEST_BODY_DATA_TYPE_METHOD = "getRequestBodyDataType";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "parameterBinding";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String PARAMETER_VALUES_LOCAL_VARIABLE = "parameterValues";
    private static final String GET_TYPED_VALUE_OR_NULL_METHOD = "getTypedValueOrNull";
    private static final String XML_STRING_DATA_TYPE = "XML_STRING";
    private static final String JSON_STRING_DATA_TYPE = "JSON_STRING";
    private static final String TEXT_STRING_DATA_TYPE = "TEXT_STRING";
    private final Trigger trigger;
    private final SdkTriggerOutputMetadataResolver outputMetadataResolver;
    private SdkSampleDataProviderTrigger sdkSampleDataProviderTrigger;

    public SdkTrigger(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.trigger = trigger;
        this.outputMetadataResolver = this.buildOutputMetadataResolver(outputDir, connectorModel, sdkConnector, trigger, runConfiguration);
    }

    private SdkTriggerOutputMetadataResolver buildOutputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        return new SdkTriggerOutputMetadataResolver(outputDir, connectorModel, sdkConnector, trigger.getOperation(), trigger.getTriggerOutputType(), trigger.getName(), runConfiguration);
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.source";
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml(this.trigger.getInternalName()) + "Trigger";
    }

    private void generateTriggerClass() throws TemplatingException {
        TypeSpec.Builder triggerClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(RestPollingSource.class).addMethod(this.generateConstructor()).addMethod(this.generateWatermarkDataTypeMethod()).addMethod(this.generateGetPathTemplateMethod()).addMethod(this.generateGetRequestBuilderMethod()).addMethod(this.generateGetParameterBindingMethod()).addMethod(this.generateGetParameterValuesMethod()).addMethod(this.generateGetRequestBodyDataTypeMethod());
        this.addClassConstants(triggerClassBuilder);
        this.addParameters(triggerClassBuilder);
        this.sdkSampleDataProviderTrigger = this.addSampleData(triggerClassBuilder);
        if (this.outputMetadataResolver != null && this.outputMetadataResolver.getRequiresMetadataResolver()) {
            triggerClassBuilder.addAnnotation(this.getMetadataScopeAnnotation());
        }
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(triggerClassBuilder.build(), this.getPackage());
        javaFileBuilder.addStaticImport(RestSdkUtils.class, new String[]{GET_TYPED_VALUE_OR_NULL_METHOD});
        this.writeJavaFile(javaFileBuilder.build());
    }

    private AnnotationSpec getMetadataScopeAnnotation() {
        return AnnotationSpec.builder(MetadataScope.class).addMember("outputResolver", "$T.class", new Object[]{ClassName.get((String)this.outputMetadataResolver.getPackage(), (String)this.outputMetadataResolver.getClassName(), (String[])new String[0])}).build();
    }

    private SdkSampleDataProviderTrigger addSampleData(TypeSpec.Builder triggerClassBuilder) {
        SdkSampleDataProviderTrigger sampleDataProvider = null;
        if (this.trigger.getSampleData()) {
            sampleDataProvider = new SdkSampleDataProviderTrigger(this.outputDir, this.connectorModel, this, this.trigger, this.runConfiguration);
            triggerClassBuilder.addAnnotation(this.generateSampleDataAnnotation(sampleDataProvider));
        }
        return sampleDataProvider;
    }

    private AnnotationSpec generateSampleDataAnnotation(SdkSampleDataProviderTrigger sdkSampleDataProviderTrigger) {
        return AnnotationSpec.builder(SampleData.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)sdkSampleDataProviderTrigger.getPackage(), (String)sdkSampleDataProviderTrigger.getJavaClassName(), (String[])new String[0])}).build();
    }

    private MethodSpec generateGetRequestBodyDataTypeMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BODY_DATA_TYPE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(DataType.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $T.$L", new Object[]{DataType.class, this.getRequestBodyDataType()});
        return methodBuilder.build();
    }

    private String getRequestBodyDataType() {
        TypeDefinition inputMetadata = this.trigger.getOperation().getInputMetadata();
        if (inputMetadata == null || inputMetadata.getMediaType() == null) {
            return JSON_STRING_DATA_TYPE;
        }
        if (inputMetadata.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return JSON_STRING_DATA_TYPE;
        }
        if (inputMetadata.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return XML_STRING_DATA_TYPE;
        }
        if (inputMetadata.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE)) {
            return TEXT_STRING_DATA_TYPE;
        }
        return JSON_STRING_DATA_TYPE;
    }

    private void addParameters(TypeSpec.Builder triggerClassBuilder) {
        for (TriggerParameter parameter : this.trigger.getParameters()) {
            triggerClassBuilder.addField(this.getParameter(parameter));
        }
    }

    private FieldSpec getParameter(TriggerParameter parameter) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder(this.getJavaType(parameter.getParameterType()), (String)JavaUtils.getJavaLowerCamelNameFromXml(parameter.getInternalName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class).addAnnotation(this.getAnnotationWithValue(DisplayName.class, parameter.getDisplayName()));
        if (StringUtils.isNotBlank((CharSequence)parameter.getDescription())) {
            fieldBuilder.addAnnotation(this.getAnnotationWithValue(Summary.class, parameter.getDescription()));
        }
        if (!parameter.isRequired()) {
            fieldBuilder.addAnnotation(Optional.class);
        }
        return fieldBuilder.build();
    }

    private AnnotationSpec getAnnotationWithValue(Class<?> annotationClass, String value) {
        return AnnotationSpec.builder(annotationClass).addMember("value", "$S", new Object[]{value}).build();
    }

    private void addClassConstants(TypeSpec.Builder triggerClassBuilder) {
        triggerClassBuilder.addField(this.getConstantStringField(PATH_TEMPLATE_FIELD, this.trigger.getOperation().getPath())).addField(this.getConstantStringField(ITEMS_EXPRESSION_FIELD, this.trigger.getItemsExpression())).addField(this.getConstantStringField(WATERMARK_EXPRESSION_FIELD, this.trigger.getWatermarkExpression())).addField(this.getConstantStringField(IDENTITY_EXPRESSION_FIELD, this.trigger.getIdentityExpression())).addField(this.getConstantStringField(REQUEST_BODY_EXPRESSION_FIELD, this.trigger.getRequestBodyExpression()));
    }

    private MethodSpec generateConstructor() {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addStatement("super($L, $L, $L, $L)", new Object[]{ITEMS_EXPRESSION_FIELD, WATERMARK_EXPRESSION_FIELD, IDENTITY_EXPRESSION_FIELD, REQUEST_BODY_EXPRESSION_FIELD});
        return constructorBuilder.build();
    }

    private MethodSpec generateWatermarkDataTypeMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)WATERMARK_DATA_TYPE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(DataType.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $T.fromType($T.class)", new Object[]{DataType.class, this.getJavaType(this.trigger.getWatermarkType())});
        return methodBuilder.build();
    }

    private MethodSpec generateGetPathTemplateMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PATH_TEMPLATE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $L", new Object[]{PATH_TEMPLATE_FIELD});
        return methodBuilder.build();
    }

    private MethodSpec generateGetRequestBuilderMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BUILDER_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RestRequestBuilder.class).addAnnotation(Override.class).addParameter(String.class, "path", new Modifier[0]);
        methodBuilder.addStatement("return new $T(connection.getBaseUri(), path, $T.$L)", new Object[]{RestRequestBuilder.class, HttpConstants.Method.class, this.trigger.getOperation().getHttpMethod().toUpperCase()});
        return methodBuilder.build();
    }

    private MethodSpec generateGetParameterBindingMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_BINDING_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RequestParameterBinding.class).addAnnotation(Override.class);
        methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{RequestParameterBinding.class, PARAMETER_BINDING_LOCAL_VARIABLE});
        if (this.trigger.getParameterBindings() != null) {
            for (ParameterBinding binding : this.trigger.getParameterBindings()) {
                methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, this.getParameterBindingAddMethodName(binding), binding.getName(), binding.getExpression()});
            }
        }
        methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private String getParameterBindingAddMethodName(ParameterBinding binding) {
        switch (binding.getParameterType()) {
            case QUERY: {
                return ADD_QUERY_BINDING_METHOD;
            }
            case HEADER: {
                return ADD_HEADER_BINDING_METHOD;
            }
            case URI: {
                return ADD_URI_BINDING_METHOD;
            }
        }
        throw new IllegalArgumentException("Parameter type not supported: " + (Object)((Object)binding.getParameterType()));
    }

    private MethodSpec generateGetParameterValuesMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_VALUES_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.getParameterValuesMultiMapType()).addAnnotation(Override.class);
        methodBuilder.addStatement("final $T $L = new $T<>()", new Object[]{this.getParameterValuesMultiMapType(), PARAMETER_VALUES_LOCAL_VARIABLE, MultiMap.class});
        for (TriggerParameter parameter : this.trigger.getParameters()) {
            methodBuilder.addStatement("$L.put($S, $L($L))", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE, parameter.getExternalName(), GET_TYPED_VALUE_OR_NULL_METHOD, JavaUtils.getJavaLowerCamelNameFromXml(parameter.getInternalName())});
        }
        methodBuilder.addStatement("return $L", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private ParameterizedTypeName getParameterValuesMultiMapType() {
        ParameterizedTypeName wildcardTypedValueType = ParameterizedTypeName.get((ClassName)ClassName.get(TypedValue.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        return ParameterizedTypeName.get((ClassName)ClassName.get(MultiMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), wildcardTypedValueType});
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.outputMetadataResolver != null) {
            this.outputMetadataResolver.applyTemplates();
        }
        this.generateTriggerClass();
        if (this.sdkSampleDataProviderTrigger != null) {
            this.sdkSampleDataProviderTrigger.applyTemplates();
        }
    }
}

