/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class NamingUtil {
    private static final Pattern CHARACTER_SPLIT_PATTERN = Pattern.compile("([a-zA-Z0-9])([\\-_.]+)([a-zA-Z0-9]*)");

    private NamingUtil() {
    }

    public static boolean isFriendlyName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        if (name.contains(" ")) {
            return true;
        }
        return ParserUtils.splitCaps(name, " ").equalsIgnoreCase(name) && !CHARACTER_SPLIT_PATTERN.matcher(name).find();
    }

    public static String makeNameFriendly(String name) {
        String friendlyName = name.trim();
        if (friendlyName.contains(" ")) {
            return friendlyName;
        }
        while (CHARACTER_SPLIT_PATTERN.matcher(friendlyName).find()) {
            friendlyName = CHARACTER_SPLIT_PATTERN.matcher(friendlyName).replaceAll("$1 $3");
        }
        if ((friendlyName = ParserUtils.splitCaps(friendlyName, " ")).toUpperCase().equals(friendlyName)) {
            friendlyName = friendlyName.toLowerCase();
        }
        return org.apache.commons.lang3.StringUtils.capitalize((String)friendlyName);
    }

    public static String buildParameterInternalName(String externalName, List<String> collisionInternalNames, ParameterType parameterType) {
        String name = XmlUtils.getXmlName(externalName);
        if (collisionInternalNames != null && collisionInternalNames.stream().anyMatch(x -> x.equalsIgnoreCase(name))) {
            return name + "-" + XmlUtils.getXmlName(parameterType.getName());
        }
        return name;
    }
}

