/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ModelValidator;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationEngine.class);
    private static final ModelValidator VALIDATOR = ModelValidator.defaultModelValidator();
    private ConnectorDescriptor connectorDescriptor;
    private APIModel apiModel;

    public boolean preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        this.connectorDescriptor = connectorDescriptor;
        this.apiModel = apiModel;
        List<ValidationResult> validationResults = VALIDATOR.preValidate(apiModel, connectorDescriptor);
        this.reportValidationResults(validationResults);
        return validationResults.stream().noneMatch(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR));
    }

    public boolean postValidate(ConnectorModel connectorModel) {
        List<ValidationResult> validationResults = VALIDATOR.postValidate(this.apiModel, this.connectorDescriptor, connectorModel);
        this.reportValidationResults(validationResults);
        return validationResults.stream().noneMatch(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR));
    }

    private void reportValidationResults(List<ValidationResult> validationResults) {
        List<ValidationResult> errorList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR)).collect(Collectors.toList());
        List<ValidationResult> warnList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.WARN)).collect(Collectors.toList());
        List<ValidationResult> infoList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.INFO)).collect(Collectors.toList());
        errorList.forEach(x -> LOGGER.error(x.toString() + System.lineSeparator()));
        warnList.forEach(x -> LOGGER.warn(x.toString() + System.lineSeparator()));
        infoList.forEach(x -> LOGGER.warn(x.toString() + System.lineSeparator()));
    }
}

