/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APITypeModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DescriptorInputMediaTypeMustBePresentInApiRule
extends PreValidationRule {
    public DescriptorInputMediaTypeMustBePresentInApiRule() {
        super("The input media type defined in the descriptor is not present in the API spec", "If the API spec defines a set of input media types for an operation the Descriptor must use one of those to define the operation's default input media type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> allErrors = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpointDesc : connectorDescriptor.getEndpoints()) {
            List errors = endpointDesc.getOperations().stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getInputMediaType())).filter(x -> this.apiDefinesMediaTypes(apiModel, endpointDesc.getPath(), (OperationDescriptor)x)).filter(x -> !this.mediaTypePresentInApi(apiModel, endpointDesc.getPath(), (OperationDescriptor)x)).map(x -> this.getValidationErrorForDescriptor(endpointDesc.getPath(), x.getMethod(), x.getInputMediaType())).collect(Collectors.toList());
            allErrors.addAll(errors);
        }
        String globalMediaType = connectorDescriptor.getDefaultInputMediaType();
        if (StringUtils.isNotBlank((CharSequence)globalMediaType)) {
            List globalErrors = apiModel.getOperationsModel().stream().filter(x -> !x.getInputMetadataModel().isEmpty()).filter(x -> x.getInputMetadataModel().stream().anyMatch(y -> y.getMediaType() != null)).filter(x -> !this.descriptorDefinesMediaType(connectorDescriptor, (APIOperationModel)x)).filter(x -> !this.descriptorDefinesOperationMediaType(globalMediaType, (APIOperationModel)x)).map(x -> this.getValidationErrorForDescriptor(x.getPath(), x.getHttpMethod().name(), globalMediaType)).collect(Collectors.toList());
            allErrors.addAll(globalErrors);
        }
        return allErrors;
    }

    protected boolean descriptorDefinesOperationMediaType(String globalMediaType, APIOperationModel apiOperationModel) {
        return apiOperationModel.getInputMetadataModel().stream().anyMatch(y -> y.getMediaType().toString().equalsIgnoreCase(globalMediaType));
    }

    private boolean descriptorDefinesMediaType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperation.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperation.getHttpMethod().name())).anyMatch(x -> StringUtils.isNotBlank((CharSequence)x.getInputMediaType()));
    }

    private boolean mediaTypePresentInApi(APIModel apiModel, String path, OperationDescriptor operationDesc) {
        String inputMediaType = operationDesc.getInputMediaType();
        String method = operationDesc.getMethod();
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().name().equalsIgnoreCase(method)).flatMap(x -> x.getInputMetadataModel().stream()).map(APITypeModel::getMediaType).anyMatch(x -> x.toString().equalsIgnoreCase(inputMediaType));
    }

    private boolean apiDefinesMediaTypes(APIModel apiModel, String path, OperationDescriptor operationDesc) {
        String method = operationDesc.getMethod();
        Optional<APIOperationModel> any = apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().name().equalsIgnoreCase(method)).filter(x -> !x.getInputMetadataModel().isEmpty()).findAny();
        return any.isPresent();
    }

    private ValidationResult getValidationErrorForDescriptor(String path, String method, String mediaType) {
        String location = "Operation with PATH: " + path + " and METHOD: " + method + " does not declare '" + mediaType + "' media type";
        return new ValidationResult(this, location);
    }
}

