/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DescriptorParameterMustBePresentInApiRule
extends PreValidationRule {
    public DescriptorParameterMustBePresentInApiRule() {
        super("Operation parameters declared in the connector descriptor must be present in the API spec", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> results = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                if (operationDescriptor.getExpects() == null) continue;
                results.addAll(this.validateParametersExists(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
                results.addAll(this.validateParametersExists(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
                results.addAll(this.validateParametersExists(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
            }
        }
        return results;
    }

    private List<ValidationResult> validateParametersExists(List<ParameterDescriptor> parameters, ParameterType parameterType, String path, String method, APIModel apiModel) {
        return parameters.stream().map(x -> this.validateParameterExists((ParameterDescriptor)x, parameterType, path, method, apiModel)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ValidationResult validateParameterExists(ParameterDescriptor parameter, ParameterType parameterType, String path, String method, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path)).filter(x -> x.getHttpMethod().name().equalsIgnoreCase(method)).findFirst().map(x -> this.validateParameterExists((APIOperationModel)x, parameter, parameterType)).orElse(null);
    }

    private ValidationResult validateParameterExists(APIOperationModel apiOperation, ParameterDescriptor parameter, ParameterType parameterType) {
        List<APIParameterModel> apiParameterList = parameterType.equals((Object)ParameterType.URI) ? apiOperation.getUriParamsModel() : (parameterType.equals((Object)ParameterType.QUERY) ? apiOperation.getQueryParamsModel() : apiOperation.getHeadersModel());
        return apiParameterList.stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameter.getParamName())) ? null : this.getValidationError(apiOperation, parameter, parameterType);
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel, ParameterDescriptor parameter, ParameterType parameterType) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name() + " does not declare a " + parameterType.getName() + " named " + parameter.getParamName();
        return new ValidationResult(this, location);
    }
}

