/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExtensionXmlMustBeValidRule
extends PreValidationRule {
    public ExtensionXmlMustBeValidRule() {
        super("Descriptor extensionXml property must be xml valid", "When present in the connector descriptor, extensionXml property must be a xml valid name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String extensionXml = connectorDescriptor.getExtensionXml();
        if (StringUtils.isBlank((CharSequence)extensionXml)) {
            return validationResults;
        }
        String xmlValidExtensionXml = XmlUtils.getXmlName(extensionXml);
        if (!extensionXml.equalsIgnoreCase(xmlValidExtensionXml)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "Descriptor extensionXml");
    }
}

