/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.LinkedList;
import java.util.List;

public class GavGroupIdMustBeValidRule
extends PreValidationRule {
    public GavGroupIdMustBeValidRule() {
        super("Descriptor connectorGav's groupId must ve a valid Maven groupId", "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String groupId = connectorDescriptor.getConnectorGav().getGroupId();
        String validGroupId = XmlUtils.removeMavenGroupUnwantedCharacters(groupId);
        String validJavaPackageGroupId = JavaUtils.removeJavaPackageUnwantedCharacters(groupId);
        if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "'groupId' property declared in the connector descriptor's 'connectorGav' property");
    }
}

