/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.LinkedList;
import java.util.List;

public class GavVersionMustBeValidRule
extends PreValidationRule {
    public GavVersionMustBeValidRule() {
        super("Descriptor connectorGav's version must ve a valid Maven version", "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        String validVersion;
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String version = connectorDescriptor.getConnectorGav().getVersion();
        if (!version.equalsIgnoreCase(validVersion = XmlUtils.removeMavenVersionUnwantedCharacters(version))) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "'version' property declared in the connector descriptor's 'connectorGav' property");
    }
}

