/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NoDefaultInputMediaTypeDefinedRule
extends PreValidationRule {
    public NoDefaultInputMediaTypeDefinedRule() {
        super("No default inputMediaType was set in the Descriptor and multiple are available", "", ValidationRule.Level.INFO);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getInputMetadataModel().size() > 1).filter(x -> !this.operationHasDefaultInputType(connectorDescriptor, (APIOperationModel)x)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean operationHasDefaultInputType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).anyMatch(x -> StringUtils.isNotBlank((CharSequence)x.getInputMediaType()));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + (Object)((Object)apiOperationModel.getHttpMethod());
        return new ValidationResult(this, location);
    }
}

