/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NoInputMediaTypeDefinedRule
extends PreValidationRule {
    public NoInputMediaTypeDefinedRule() {
        super("Defining a media type for the operations input type is mandatory", "If an operation defines an input type it should also define a media type. This can be done at the operation level or globally.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getDefaultInputMediaType())) {
            return Collections.emptyList();
        }
        LinkedList<ValidationResult> allErrors = new LinkedList<ValidationResult>();
        apiModel.getOperationsModel().stream().filter(x -> !x.getInputMetadataModel().isEmpty()).filter(x -> !this.inputMediaTypeDefinedInAPISpec((APIOperationModel)x)).filter(x -> !this.inputMediaTypeDefinedInDescriptor((APIOperationModel)x, connectorDescriptor)).map(this::getValidationErrorForApiSpec).forEach(allErrors::add);
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            endpoint.getOperations().stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getInputTypeSchema())).filter(x -> StringUtils.isBlank((CharSequence)x.getInputMediaType())).filter(x -> !this.inputMediaTypeDefinedInAPISpec(apiModel, endpoint.getPath(), x.getMethod())).map(x -> this.getValidationErrorForDescriptor(endpoint.getPath(), x.getMethod())).forEach(allErrors::add);
        }
        return allErrors;
    }

    private boolean inputMediaTypeDefinedInAPISpec(APIOperationModel apiOperation) {
        return apiOperation.getInputMetadataModel().stream().anyMatch(x -> x.getMediaType() != null);
    }

    private boolean inputMediaTypeDefinedInAPISpec(APIModel apiModel, String path, String method) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().name().equalsIgnoreCase(method)).flatMap(x -> x.getInputMetadataModel().stream()).anyMatch(x -> x.getMediaType() != null);
    }

    private boolean inputMediaTypeDefinedInDescriptor(APIOperationModel apiOperationModel, ConnectorDescriptor descriptor) {
        OperationDescriptor operationDescriptor = descriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getInputMediaType());
    }

    private ValidationResult getValidationErrorForApiSpec(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name() + " defined in the API spec";
        return new ValidationResult(this, location);
    }

    private ValidationResult getValidationErrorForDescriptor(String path, String method) {
        String location = "Operation with PATH: " + path + " and METHOD: " + method + " defined in the Connector Descriptor";
        return new ValidationResult(this, location);
    }
}

