/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverReferenceArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueResolverReferenceArgumentsExistsRule
extends PreValidationRule {
    public ValueResolverReferenceArgumentsExistsRule() {
        super("When sending an argument to a value resolver it must exist in the value resolver declaration", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List<ValueResolverDescriptor> valueResolvers = connectorDescriptor.getValueResolvers();
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                if (operation.getExpects() == null) continue;
                validationResults.addAll(this.validateOperationParameters(valueResolvers, endpoint, operation, operation.getExpects().getUriParameter()));
                validationResults.addAll(this.validateOperationParameters(valueResolvers, endpoint, operation, operation.getExpects().getQueryParameter()));
                validationResults.addAll(this.validateOperationParameters(valueResolvers, endpoint, operation, operation.getExpects().getHeader()));
            }
        }
        return validationResults;
    }

    private List<ValidationResult> validateOperationParameters(List<ValueResolverDescriptor> valueResolvers, EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, List<ParameterDescriptor> parameterDescriptors) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (ParameterDescriptor parameter : parameterDescriptors) {
            ValueResolverDescriptor valueResolver;
            if (parameter.getValueResolver() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValueResolver().getId()) || (valueResolver = (ValueResolverDescriptor)valueResolvers.stream().filter(x -> x.getName().equals(parameter.getValueResolver().getId())).findFirst().orElse(null)) == null) continue;
            List valueResolverValidParameterNames = valueResolver.getParameters().stream().map(ValueResolverParameterDescriptor::getName).collect(Collectors.toList());
            if (parameter.getValueResolver().getArguments() == null || parameter.getValueResolver().getArguments().isEmpty()) continue;
            validationResults.addAll(parameter.getValueResolver().getArguments().stream().filter(x -> valueResolverValidParameterNames.stream().noneMatch(y -> y.equals(x.getName()))).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, parameter, (ValueResolverReferenceArgumentDescriptor)x)).collect(Collectors.toList()));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ValueResolverReferenceArgumentDescriptor argument) {
        String location = parameterDescriptor.getParamName() + " parameter declared for the operation with PATH'" + endPointDescriptor.getPath() + " and METHOD: " + operationDescriptor.getMethod() + "in the connector descriptor is declaring an invalid argument for its value resolver: '" + argument.getName() + "'";
        return new ValidationResult(this, location);
    }
}

