/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ValueResolverReferenceExistsRule
extends PreValidationRule {
    public ValueResolverReferenceExistsRule() {
        super("Value resolver reference id set for parameters must exist in the connector descriptor", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List<String> valueResolverIds = connectorDescriptor.getValueResolvers().stream().map(ValueResolverDescriptor::getName).collect(Collectors.toList());
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                if (operation.getExpects() == null) continue;
                validationResults.addAll(this.validateOperationParameters(valueResolverIds, endpoint, operation, operation.getExpects().getUriParameter()));
                validationResults.addAll(this.validateOperationParameters(valueResolverIds, endpoint, operation, operation.getExpects().getQueryParameter()));
                validationResults.addAll(this.validateOperationParameters(valueResolverIds, endpoint, operation, operation.getExpects().getHeader()));
            }
        }
        return validationResults;
    }

    private List<ValidationResult> validateOperationParameters(List<String> validValueResolverIds, EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, List<ParameterDescriptor> parameterDescriptors) {
        if (parameterDescriptors == null) {
            return Collections.emptyList();
        }
        return parameterDescriptors.stream().filter(x -> !this.isValidValueResolverId(validValueResolverIds, (ParameterDescriptor)x)).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, (ParameterDescriptor)x)).collect(Collectors.toList());
    }

    private boolean isValidValueResolverId(List<String> validValueResolverIds, ParameterDescriptor parameter) {
        if (parameter.getValueResolver() == null) {
            return true;
        }
        if (validValueResolverIds == null || validValueResolverIds.isEmpty()) {
            return false;
        }
        if (parameter.getValueResolver().getId() == null) {
            return false;
        }
        return validValueResolverIds.stream().anyMatch(y -> parameter.getValueResolver().getId().equals(y));
    }

    private ValidationResult getValidationError(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor) {
        String location = "'" + parameterDescriptor.getParamName() + "' parameter declared for the operation with PATH '" + endPointDescriptor.getPath() + "' and METHOD: '" + operationDescriptor.getMethod() + "' on the connector descriptor is declaring an invalid value resolver: '" + parameterDescriptor.getValueResolver().getId() + "'";
        return new ValidationResult(this, location);
    }
}

