/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class TypeSchemaPool {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Map<String, TypeSchema> innerJsonPool = new HashMap<String, TypeSchema>();
    private final Map<String, TypeSchema> innerSchemaPool = new HashMap<String, TypeSchema>();

    public TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
        TypeSchema returnSchema;
        String rawSchema = typeSchema.getRawSchema();
        boolean isJsonSchema = this.isJsonSchema(rawSchema);
        if (isJsonSchema) {
            String first = this.innerJsonPool.keySet().stream().filter(x -> this.isEqualJsonSchema((String)x, rawSchema)).findFirst().orElse(null);
            returnSchema = this.innerJsonPool.get(first);
        } else {
            returnSchema = this.innerSchemaPool.get(rawSchema);
        }
        if (returnSchema == null) {
            return this.putTypeSchema(typeSchema, isJsonSchema);
        }
        return returnSchema;
    }

    private TypeSchema putTypeSchema(TypeSchema typeSchema, boolean isJsonSchema) {
        if (isJsonSchema) {
            this.innerJsonPool.put(typeSchema.getRawSchema(), typeSchema);
        } else {
            this.innerSchemaPool.put(typeSchema.getRawSchema(), typeSchema);
        }
        return typeSchema;
    }

    private boolean isJsonSchema(String rawSchema) {
        try {
            MAPPER.readTree(rawSchema);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isEqualJsonSchema(String schemaA, String schemaB) {
        if (schemaA.equals(schemaB)) {
            return true;
        }
        return !JSONCompare.compareJSON((String)schemaA, (String)schemaB, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE).failed();
    }
}

