/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.client.model.domain.ApiKeySettings;
import amf.client.model.domain.HttpSettings;
import amf.client.model.domain.OAuth2Flow;
import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.SecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BasicAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.DigestAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.NotSupportedScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.PassThroughScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security.AMFOauth2FlowsNaming;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security.AMFSecuritySchemesNaming;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AMFSecuritySchemeModel
extends APISecuritySchemeModel {
    private final SecurityScheme securityScheme;
    private final OAuth2Flow oAuth2Flow;

    public AMFSecuritySchemeModel(SecurityScheme securityScheme) {
        this(securityScheme, null);
    }

    public AMFSecuritySchemeModel(SecurityScheme securityScheme, OAuth2Flow oAuth2Flow) {
        this.securityScheme = securityScheme;
        this.oAuth2Flow = oAuth2Flow;
        this.name = securityScheme.name().value();
        this.securitySchemeClass = this.buildSecuritySchemeClass();
        this.customHeaders = this.buildCustomHeadersModel();
        this.customQueryParams = this.buildCustomQueryParamsModel();
        this.accessTokenUri = this.buildAccessTokenUri();
        this.authorizationUri = this.buildAuthorizationUri();
        this.scopes = this.buildScopes();
    }

    private String buildAccessTokenUri() {
        if (this.oAuth2Flow != null) {
            return this.oAuth2Flow.accessTokenUri().value();
        }
        return null;
    }

    private String buildAuthorizationUri() {
        if (this.oAuth2Flow != null) {
            return this.oAuth2Flow.authorizationUri().value();
        }
        return null;
    }

    private List<String> buildScopes() {
        if (this.oAuth2Flow != null) {
            return this.oAuth2Flow.scopes().stream().map(x -> x.name().value()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Class<? extends ConnectorSecurityScheme> buildSecuritySchemeClass() {
        String schemeType = this.securityScheme.type().value();
        if (AMFSecuritySchemesNaming.isBasicAuth(schemeType, this.getHttpSettingsScheme())) {
            return BasicAuthScheme.class;
        }
        if (AMFSecuritySchemesNaming.isPassThrough(schemeType)) {
            return PassThroughScheme.class;
        }
        if (AMFSecuritySchemesNaming.isApiKey(schemeType)) {
            return PassThroughScheme.class;
        }
        if (AMFSecuritySchemesNaming.isOauth2(schemeType)) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)this.securityScheme.settings();
            if (AMFOauth2FlowsNaming.isAuthorizationCode(oAuth2Settings, this.oAuth2Flow)) {
                return OAuth2AuthorizationCodeScheme.class;
            }
            if (AMFOauth2FlowsNaming.isClientCredentials(oAuth2Settings, this.oAuth2Flow)) {
                return OAuth2ClientCredentialsScheme.class;
            }
        } else {
            if (AMFSecuritySchemesNaming.isDigest(schemeType)) {
                return DigestAuthenticationScheme.class;
            }
            if (AMFSecuritySchemesNaming.isCustom(schemeType)) {
                return CustomAuthenticationScheme.class;
            }
        }
        return NotSupportedScheme.class;
    }

    private String getHttpSettingsScheme() {
        String httpScheme = null;
        if (this.securityScheme.settings() instanceof HttpSettings) {
            httpScheme = ((HttpSettings)this.securityScheme.settings()).scheme().value();
        }
        return httpScheme;
    }

    private List<APIParameterModel> buildCustomQueryParamsModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        for (Parameter x : this.securityScheme.queryParameters()) {
            AMFParameterModel parameterModel = new AMFParameterModel(x, ParameterType.QUERY, false);
            list.add(parameterModel);
        }
        AMFParameterModel queryParam = this.getApiKeyParameter("query");
        if (queryParam != null) {
            list.add(queryParam);
        }
        return list;
    }

    private List<APIParameterModel> buildCustomHeadersModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        for (Parameter x : this.securityScheme.headers()) {
            AMFParameterModel parameterModel = new AMFParameterModel(x, ParameterType.HEADER, false);
            list.add(parameterModel);
        }
        AMFParameterModel header = this.getApiKeyParameter("header");
        if (header != null) {
            list.add(header);
        }
        return list;
    }

    private AMFParameterModel getApiKeyParameter(String from) {
        if (this.securityScheme.settings() instanceof ApiKeySettings) {
            String in = ((ApiKeySettings)this.securityScheme.settings()).in().value();
            String name = ((ApiKeySettings)this.securityScheme.settings()).name().value();
            String string = name = StringUtils.isNotBlank((CharSequence)name) ? name : "api-key";
            if (in.equalsIgnoreCase(from)) {
                return new AMFParameterModel(name, ParameterType.SECURITY, new AMFPrimitiveTypeModel(PrimitiveTypeDefinition.PrimitiveType.STRING));
            }
        }
        return null;
    }
}

