/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

public class DescriptorRedundantOutputDefinitionRule extends PreValidationRule {

  //R021
  public DescriptorRedundantOutputDefinitionRule() {
    super("Operation descriptor's properties 'skipOutputTypeValidation', 'voidOperation' and 'outputType' are mutually exclusive.",
          EMPTY,
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> allValidationErrors = new LinkedList<>();

    for (EndPointDescriptor epDesc : connectorDescriptor.getEndpoints()) {
      List<ValidationError> validationErrors = epDesc.getOperations().stream()
          .filter(this::moreThanOneExclusiveProperty)
          .map(this::getValidationError)
          .collect(toList());

      allValidationErrors.addAll(validationErrors);
    }

    return allValidationErrors;
  }

  private boolean moreThanOneExclusiveProperty(OperationDescriptor operationDescriptor) {
    int count = 0;

    if (operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation()) {
      count++;
    }

    if (operationDescriptor.getSkipOutputTypeValidation() != null && operationDescriptor.getSkipOutputTypeValidation()) {
      count++;
    }

    if (isNotBlank(operationDescriptor.getOutputTypeSchema())) {
      count++;
    }

    return count > 1;
  }

  private ValidationError getValidationError(OperationDescriptor operationDescriptor) {
    return new ValidationError(this, EMPTY, operationDescriptor.getLocation());
  }
}
