/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.LinkedList;
import java.util.List;

public class GavGroupIdMustBeValidRule
extends PreValidationRule {
    public GavGroupIdMustBeValidRule() {
        super("Descriptor connectorGav's groupId must ve a valid Maven groupId", "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        String groupId = connectorDescriptor.getConnectorGav().getGroupId();
        String validGroupId = XmlUtils.removeMavenGroupUnwantedCharacters((String)groupId);
        String validJavaPackageGroupId = JavaUtils.removeJavaPackageUnwantedCharacters((String)groupId);
        if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
            validationErrors.add(this.getValidationError(connectorDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = "Group Id '" + connectorDescriptor.getConnectorGav().getGroupId() + "' is not a valid Maven groupId";
        return new ValidationError(this, detail, connectorDescriptor.getLocation());
    }
}

