/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod.GET;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataTypeDescriptor.SAME_OPERATION;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.WARN;
import static org.apache.commons.lang.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.HttpMethodDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class SampleDataMarkerMustBeGETRule extends PreValidationRule {

  public SampleDataMarkerMustBeGETRule() {
    super("Sample Data marker (same-operation) cannot be used in POST/PUT/DELETE/PATCH methods, ignoring this one.",
          "Sample Data marker (same-operation) is only available for GET method, others will be ignored.",
          WARN);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> results = new ArrayList<>();

    for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
      for (OperationDescriptor operation : endpoint.getOperations()) {
        String method = operation.getMethod();
        if (sampleDataMarkerWithoutGET(operation.getSampleDataDescriptor(), method)) {
          ValidationError vr = new ValidationError(this, EMPTY, operation.getLocation());
          results.add(vr);
        }
      }
    }

    for (TriggerDescriptor trigger : connectorDescriptor.getTriggers()) {
      HttpMethodDescriptor method = trigger.getMethod();
      if (sampleDataMarkerWithoutGET(trigger.getSampleDataDescriptor(), method.getName())) {
        ValidationError vr = new ValidationError(this, EMPTY, trigger.getLocation());
        results.add(vr);
      }
    }
    return results;
  }

  private boolean sampleDataMarkerWithoutGET(SampleDataDescriptor sampleDataDescriptor, String method) {
    return sampleDataDescriptor != null
        && sampleDataDescriptor.getType() == SAME_OPERATION
        && GET != HTTPMethod.fromString(method.toUpperCase());
  }
}
