/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ParameterNameMustBeFriendlyRule
extends PreValidationRule {
    public ParameterNameMustBeFriendlyRule() {
        super("Parameter display name seems not to be a friendly name", "The displayName should be a human readable name separated with spaces.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationError> results = new LinkedList<ValidationError>();
        for (EndPointDescriptor endpointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endpointDescriptor.getOperations()) {
                if (operationDescriptor.getExpects() == null) continue;
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, operationDescriptor, endpointDescriptor));
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, operationDescriptor, endpointDescriptor));
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, operationDescriptor, endpointDescriptor));
            }
        }
        return results;
    }

    List<ValidationError> validateParameterNames(List<ParameterDescriptor> parameters, ParameterType parameterType, OperationDescriptor operationDescriptor, EndPointDescriptor endpointDescriptor) {
        return parameters.stream().filter(x -> !NamingUtil.isFriendlyName((String)x.getFriendlyName())).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, (ParameterDescriptor)x, parameterType)).collect(Collectors.toList());
    }

    private ValidationError getValidationError(EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ParameterType parameterType) {
        String detail = "Operation with PATH: " + endpointDescriptor.getPath() + " and METHOD: " + operationDescriptor.getMethod().toUpperCase() + " declares a " + parameterType.getName() + " whose display name is '" + parameterDescriptor.getFriendlyName() + "' and it is not friendly";
        return new ValidationError(this, detail, operationDescriptor.getLocation());
    }
}

