/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NoDefaultInputMediaTypeDefinedRule
extends PreValidationRule {
    public NoDefaultInputMediaTypeDefinedRule() {
        super("No default inputMediaType was set in the Descriptor and multiple are available", "", ValidationRule.Level.INFO);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(apiOp -> apiOp.getInputMetadataModel().size() > 1).filter(apiOp -> !this.operationHasDefaultInputType(connectorDescriptor, (APIOperationModel)apiOp)).map(apiOp -> this.getValidationError(connectorDescriptor, (APIOperationModel)apiOp)).collect(Collectors.toList());
    }

    private boolean operationHasDefaultInputType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor opDesc = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        if (opDesc == null) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)opDesc.getInputMediaType());
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().toUpperCase() + " declares multiple input media types but none was selected in the Operation descriptor.";
        DescriptorElement descriptorElement = ValidationUtils.getClosestDescriptorElement(connectorDescriptor, apiOperationModel);
        return new ValidationError(this, detail, descriptorElement.getLocation());
    }
}

