/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;

import java.util.LinkedList;
import java.util.List;

public class ExtensionXmlMustBeValidRule extends PreValidationRule {

  //R005
  public ExtensionXmlMustBeValidRule() {
    super("Descriptor extensionXml property must be xml valid",
          "When present in the connector descriptor, extensionXml property must be a xml valid name.",
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> validationErrors = new LinkedList<>();

    String extensionXml = connectorDescriptor.getExtensionXml();

    if (isBlank(extensionXml)) {
      return validationErrors;
    }

    String xmlValidExtensionXml = XmlUtils.getXmlName(extensionXml);

    if (!extensionXml.equalsIgnoreCase(xmlValidExtensionXml)) {
      validationErrors.add(getValidationError(connectorDescriptor));
    }

    return validationErrors;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {

    final String detail = "'"
        + connectorDescriptor.getExtensionXml() +
        "' is not an xml valid name.";

    return new ValidationError(this, detail, connectorDescriptor.getLocation());
  }
}
