/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NoOutputMediaTypeDefinedRule
extends PreValidationRule {
    public NoOutputMediaTypeDefinedRule() {
        super("Defining a media type for the operations output type is mandatory", "If an operation defines an output type it should also define a media type. This can be done at the operation level or globally.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getDefaultOutputMediaType())) {
            return Collections.emptyList();
        }
        LinkedList<ValidationError> allErrors = new LinkedList<ValidationError>();
        apiModel.getOperationsModel().stream().filter(apiOp -> !apiOp.getOutputMetadataModel().isEmpty()).filter(apiOp -> !this.outputMediaTypeDefinedInAPISpec((APIOperationModel)apiOp)).filter(apiOp -> !this.outputMediaTypeDefinedInDescriptor((APIOperationModel)apiOp, connectorDescriptor)).map(apiOp -> this.getValidationErrorForApiSpec((APIOperationModel)apiOp, connectorDescriptor)).forEach(allErrors::add);
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            endpoint.getOperations().stream().filter(opDesc -> StringUtils.isNotBlank((CharSequence)opDesc.getOutputTypeSchema())).filter(opDesc -> StringUtils.isBlank((CharSequence)opDesc.getOutputMediaType())).filter(opDesc -> !this.outputMediaTypeDefinedInAPISpec(apiModel, endpoint.getPath(), opDesc.getMethod())).map(this::getValidationErrorForDescriptor).forEach(allErrors::add);
        }
        return allErrors;
    }

    private boolean outputMediaTypeDefinedInAPISpec(APIOperationModel apiOperation) {
        return apiOperation.getOutputMetadataModel().stream().anyMatch(x -> x.getMediaType() != null);
    }

    private boolean outputMediaTypeDefinedInAPISpec(APIModel apiModel, String path, String method) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().equalsIgnoreCase(method)).flatMap(x -> x.getOutputMetadataModel().stream()).anyMatch(x -> x.getMediaType() != null);
    }

    private boolean outputMediaTypeDefinedInDescriptor(APIOperationModel apiOperationModel, ConnectorDescriptor descriptor) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(descriptor, apiOperationModel);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputMediaType());
    }

    private ValidationError getValidationErrorForApiSpec(APIOperationModel apiOperationModel, ConnectorDescriptor connectorDescriptor) {
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod() + " defined in the API spec does not declare a media type for its output type";
        return new ValidationError(this, "", connectorDescriptor.getLocation());
    }

    private ValidationError getValidationErrorForDescriptor(OperationDescriptor operationDescriptor) {
        return new ValidationError(this, "", operationDescriptor.getLocation());
    }
}

