/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverReferenceArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueResolverReferenceArgumentsExistsRule
extends PreValidationRule {
    public ValueResolverReferenceArgumentsExistsRule() {
        super("When sending an argument to a value resolver it must exist in the value resolver declaration", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List valueResolvers = connectorDescriptor.getValueResolvers();
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                if (operation.getExpects() == null) continue;
                validationErrors.addAll(this.validateOperationParameters(valueResolvers, endpoint, operation, operation.getExpects().getUriParameter()));
                validationErrors.addAll(this.validateOperationParameters(valueResolvers, endpoint, operation, operation.getExpects().getQueryParameter()));
                validationErrors.addAll(this.validateOperationParameters(valueResolvers, endpoint, operation, operation.getExpects().getHeader()));
            }
        }
        return validationErrors;
    }

    private List<ValidationError> validateOperationParameters(List<ValueResolverDescriptor> valueResolvers, EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, List<ParameterDescriptor> parameterDescriptors) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        for (ParameterDescriptor parameter : parameterDescriptors) {
            ValueResolverDescriptor valueResolver;
            if (parameter.getValueResolver() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValueResolver().getId()) || (valueResolver = (ValueResolverDescriptor)valueResolvers.stream().filter(x -> x.getName().equals(parameter.getValueResolver().getId())).findFirst().orElse(null)) == null) continue;
            List valueResolverValidParameterNames = valueResolver.getParameters().stream().map(ValueResolverParameterDescriptor::getName).collect(Collectors.toList());
            if (parameter.getValueResolver().getArguments() == null || parameter.getValueResolver().getArguments().isEmpty()) continue;
            validationErrors.addAll(parameter.getValueResolver().getArguments().stream().filter(x -> valueResolverValidParameterNames.stream().noneMatch(y -> y.equals(x.getName()))).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, parameter, (ValueResolverReferenceArgumentDescriptor)x)).collect(Collectors.toList()));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ValueResolverReferenceArgumentDescriptor argument) {
        String detail = parameterDescriptor.getParamName() + " parameter declared for the operation with PATH'" + endPointDescriptor.getPath() + " and METHOD: " + operationDescriptor.getMethod() + " in the connector descriptor is declaring an invalid argument for its value resolver: '" + argument.getName() + "'";
        return new ValidationError(this, detail, argument.getLocation());
    }
}

