/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PostValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PagedOperationsOperationMustDeclareResponseBodyRule
extends PostValidationRule {
    public PagedOperationsOperationMustDeclareResponseBodyRule() {
        super("Paged Operations must declare a response body", "All paginated operations must declare a an output type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = connectorModel.getOperations().stream().filter(connectorOperation -> connectorOperation.getOutputMetadata() == null || connectorOperation.getOutputMetadata() instanceof EmptyTypeDefinition).map(connectorOperation -> ValidationUtils.getApiOperationModel(apiModel, connectorOperation)).map(Objects::requireNonNull).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> this.operationIsPaginated(connectorDescriptor, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.typeDefinedInDescriptor(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(nullOutputOperation -> this.getValidationError(connectorDescriptor, (APIOperationModel)nullOutputOperation)).collect(Collectors.toList());
    }

    private boolean typeDefinedInDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema());
    }

    private boolean operationIsPaginated(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination());
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        return new ValidationError(this, "", operationDescriptor.getLocation());
    }
}

