/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.ApiParser.parseModel;
import static com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity.getTemplateEngine;

import com.mulesoft.connectivity.rest.sdk.templating.api.ConnectorType;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.exception.DescriptorParsingException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParser;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationEngine;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.io.File;
import java.nio.file.Path;

public class RestSdk {

  private RestSdk() {}

  public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, String rootDir,
                                                 RestSdkRunConfiguration runConfiguration)
      throws ModelGenerationException {
    ConnectorDescriptor connectorDescriptor;
    try {
      connectorDescriptor = new DescriptorParser().parseConnectorDescriptor(descriptor);
    } catch (DescriptorParsingException e) {
      throw new ModelGenerationException("Error parsing descriptor", e);
    }

    final APIModel apiModel = parseModel(spec, format, rootDir, runConfiguration.skipValidations());

    final ValidationEngine validationEngine = new ValidationEngine();
    boolean preValidationSuccess = validationEngine.preValidate(connectorDescriptor, apiModel);

    if (!preValidationSuccess) {
      throw new ModelGenerationException("There are (pre)validation errors.");
    }

    final ConnectorModel connectorModel = new ConnectorModelBuilder().buildConnectorModel(apiModel, connectorDescriptor);
    boolean postValidationSuccess = validationEngine.postValidate(connectorModel);

    if (!postValidationSuccess) {
      throw new ModelGenerationException("There are (post)validation errors.");
    }

    return connectorModel;
  }

  public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir,
                                       Path descriptorPath, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    getTemplateEngine(connectorType, connectorModel, outputDir, descriptorPath, runConfiguration).applyTemplates();
  }
}
