/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.HttpMethodDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class SampleDataMarkerMustBeGETRule
extends PreValidationRule {
    public SampleDataMarkerMustBeGETRule() {
        super("Sample Data marker (same-operation) cannot be used in POST/PUT/DELETE/PATCH methods, ignoring this one.", "Sample Data marker (same-operation) is only available for GET method, others will be ignored.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                String method = operation.getMethod();
                if (!this.sampleDataMarkerWithoutGET(operation.getSampleDataDescriptor(), method)) continue;
                ValidationError vr = new ValidationError(this, "", operation.getLocation());
                results.add(vr);
            }
        }
        for (TriggerDescriptor trigger : connectorDescriptor.getTriggers()) {
            HttpMethodDescriptor method = trigger.getMethod();
            if (!this.sampleDataMarkerWithoutGET(trigger.getSampleDataDescriptor(), method.getName())) continue;
            ValidationError vr = new ValidationError(this, "", trigger.getLocation());
            results.add(vr);
        }
        return results;
    }

    private boolean sampleDataMarkerWithoutGET(SampleDataDescriptor sampleDataDescriptor, String method) {
        return sampleDataDescriptor != null && sampleDataDescriptor.getType() == SampleDataTypeDescriptor.SAME_OPERATION && HTTPMethod.GET != HTTPMethod.fromString((String)method.toUpperCase());
    }
}

