/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.removeJavaPackageUnwantedCharacters;
import static org.apache.commons.lang3.StringUtils.isBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

public class BaseJavaPackageMustBeValidRule extends PreValidationRule {

  //R006
  public BaseJavaPackageMustBeValidRule() {
    super("Descriptor baseJavaPackage must ve a valid java package name",
          "When present in the connector descriptor, baseJavaPackage property must be a valid java package.",
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> validationErrors = new LinkedList<>();

    String javaPackage = connectorDescriptor.getBaseJavaPackage();

    if (isBlank(javaPackage)) {
      return validationErrors;
    }

    String validJavaPackage = removeJavaPackageUnwantedCharacters(javaPackage);

    if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
      validationErrors.add(getValidationError(connectorDescriptor));
    }

    return validationErrors;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
    return new ValidationError(this, "Descriptor baseJavaPackage", connectorDescriptor.getLocation());
  }
}
