/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.exception.DescriptorParsingException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParser;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationEngine;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.ApiParser;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.ConnectorType;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import java.io.File;
import java.nio.file.Path;

public class RestSdk {
    private RestSdk() {
    }

    public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, String rootDir, RestSdkRunConfiguration runConfiguration) throws ModelGenerationException {
        ConnectorDescriptor connectorDescriptor;
        try {
            connectorDescriptor = new DescriptorParser().parseConnectorDescriptor(descriptor);
        }
        catch (DescriptorParsingException e) {
            throw new ModelGenerationException("Error parsing descriptor", (Throwable)e);
        }
        APIModel apiModel = ApiParser.parseModel((File)spec, (SpecFormat)format, (String)rootDir, (boolean)runConfiguration.skipValidations());
        ValidationEngine validationEngine = new ValidationEngine();
        boolean preValidationSuccess = validationEngine.preValidate(connectorDescriptor, apiModel);
        if (!preValidationSuccess) {
            throw new ModelGenerationException("There are (pre)validation errors.");
        }
        ConnectorModel connectorModel = new ConnectorModelBuilder().buildConnectorModel(apiModel, connectorDescriptor);
        boolean postValidationSuccess = validationEngine.postValidate(connectorModel);
        if (!postValidationSuccess) {
            throw new ModelGenerationException("There are (post)validation errors.");
        }
        return connectorModel;
    }

    public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir, Path descriptorPath, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        TemplateEntity.getTemplateEngine((ConnectorType)connectorType, (ConnectorModel)connectorModel, (Path)outputDir, (Path)descriptorPath, (RestSdkRunConfiguration)runConfiguration).applyTemplates();
    }
}

