/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import org.apache.commons.lang3.StringUtils;

public class ValidationError {
    private final ValidationRule rule;
    private final String detail;
    private final Location location;

    public ValidationError(ValidationRule rule, String detail, DescriptorElementLocation descriptorElementLocation) {
        this.rule = rule;
        this.detail = detail;
        this.location = new Location(descriptorElementLocation);
    }

    public ValidationRule getRule() {
        return this.rule;
    }

    public ValidationRule.Level getLevel() {
        return this.rule.getLevel();
    }

    public String getDetail() {
        return this.detail;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.format("[%s] Rule: %s", this.rule.getLevel().name(), this.rule.getDescription()));
        stringBuilder.append(System.lineSeparator());
        if (StringUtils.isNotBlank((CharSequence)this.rule.getExplanation())) {
            stringBuilder.append("Explanation: ").append(this.rule.getExplanation()).append(System.lineSeparator());
        }
        if (StringUtils.isNotBlank((CharSequence)this.detail)) {
            stringBuilder.append("Detail: ").append(this.detail).append(System.lineSeparator());
        }
        stringBuilder.append("Location: ").append(this.location.toString()).append(System.lineSeparator());
        return stringBuilder.toString();
    }

    public static class Location {
        private final boolean locatedInDescriptor;
        private final String file;
        private final String startLine;
        private final String endLine;

        public Location(DescriptorElementLocation descriptorLocation) {
            this.locatedInDescriptor = !(descriptorLocation instanceof DescriptorElementLocation.EmptyDescriptorElementLocation);
            this.file = descriptorLocation.getFile();
            this.startLine = descriptorLocation.getStartLine();
            this.endLine = descriptorLocation.getEndLine();
        }

        public String toString() {
            return this.locatedInDescriptor ? "File: " + this.file + " (Lines " + this.startLine + " to " + this.endLine + ")" : "File: API Specification";
        }

        public String getFile() {
            return this.file;
        }

        public String getStartLine() {
            return this.startLine;
        }

        public String getEndLine() {
            return this.endLine;
        }
    }
}

