/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExtensionXmlMustBeValidRule
extends PreValidationRule {
    public ExtensionXmlMustBeValidRule() {
        super("Descriptor extensionXml property must be xml valid", "When present in the connector descriptor, extensionXml property must be a xml valid name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        String extensionXml = connectorDescriptor.getExtensionXml();
        if (StringUtils.isBlank((CharSequence)extensionXml)) {
            return validationErrors;
        }
        String xmlValidExtensionXml = XmlUtils.getXmlName((String)extensionXml);
        if (!extensionXml.equalsIgnoreCase(xmlValidExtensionXml)) {
            validationErrors.add(this.getValidationError(connectorDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = "'" + connectorDescriptor.getExtensionXml() + "' is not an xml valid name.";
        return new ValidationError(this, detail, connectorDescriptor.getLocation());
    }
}

