/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueProviderReferenceArgumentsHaveValidFormatRule
extends PreValidationRule {
    private static final String ERROR_TEMPLATE = "Value '%s' for argument '%s' does not match the expected format.";
    private static final Pattern PATTERN = Pattern.compile("^(?:uriParameter\\.|queryParameter\\.|header\\.)\\S+$");

    public ValueProviderReferenceArgumentsHaveValidFormatRule() {
        super("Value Provider arguments must respect the valid format (i.e. uriParameter.X, queryParameter.X or header.X)", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        for (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> reference : ValidationUtils.getValueProviderReferenceDescriptors(connectorDescriptor)) {
            List arguments = reference.getArguments();
            List errors = arguments.stream().filter(x -> !this.isValidArgumentValueFormat(x.getValue())).map(this::getValidationError).collect(Collectors.toList());
            validationErrors.addAll(errors);
        }
        return validationErrors;
    }

    private boolean isValidArgumentValueFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return PATTERN.matcher(value).matches();
    }

    private ValidationError getValidationError(ArgumentDescriptor argument) {
        return new ValidationError(this, String.format(ERROR_TEMPLATE, argument.getValue(), argument.getName()), argument.getLocation());
    }
}

