/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationDisplayNameExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class OperationDisplayNameScriptMustCompileRule
extends PreValidationRule {
    public OperationDisplayNameScriptMustCompileRule() {
        super("Operation display name expression is incorrect", String.format("The 'operationDisplayName' must be revisited (current bindings are '%s')", Arrays.toString(OperationDisplayNameExpressionHandler.IMPLICIT_INPUTS)), ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> result = new ArrayList<ValidationError>();
        ExpressionDescriptor operationDisplayName = connectorDescriptor.getOperationDisplayName();
        if (operationDisplayName != null) {
            String expression = operationDisplayName.getExpression();
            try {
                new OperationDisplayNameExpressionHandler(expression);
            }
            catch (CompilationException e) {
                result.add(this.getValidationError(connectorDescriptor, e));
            }
        }
        return result;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
        String detail = "Expression in 'operationDisplayName' is not valid, error: \n" + e.getMessage();
        return new ValidationError(this, detail, connectorDescriptor.getOperationDisplayName().getLocation());
    }
}

