/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.HttpMethodDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataSameOperationDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class SampleDataMarkerMustBeGETRule
extends PreValidationRule {
    public SampleDataMarkerMustBeGETRule() {
        super("Sample Data Same Operation cannot be used in POST/PUT/DELETE/PATCH methods, ignoring this one.", "Sample Data Same Operation is only available for GET method, others will be ignored.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                String method = operation.getMethod();
                if (!this.sampleDataMarkerWithoutGET((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)operation.getSampleDataExpressionDescriptor(), method)) continue;
                ValidationError vr = new ValidationError(this, "", operation.getLocation());
                results.add(vr);
            }
        }
        for (TriggerDescriptor trigger : connectorDescriptor.getTriggers()) {
            HttpMethodDescriptor method = trigger.getMethod();
            if (!this.sampleDataMarkerWithoutGET((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)trigger.getSampleDataExpressionDescriptor(), method.getName())) continue;
            ValidationError vr = new ValidationError(this, "", trigger.getLocation());
            results.add(vr);
        }
        return results;
    }

    private boolean sampleDataMarkerWithoutGET(ResolverExpressionDescriptor<SampleDataDefinitionDescriptor> resolverExpression, String method) {
        if (resolverExpression instanceof ResolverReferenceDescriptor) {
            resolverExpression = ((ResolverReferenceDescriptor)resolverExpression).getDeclaration().getDefinition();
        }
        if (resolverExpression instanceof SampleDataSameOperationDefinitionDescriptor) {
            return HTTPMethod.fromString((String)method.toUpperCase()) != HTTPMethod.GET;
        }
        return false;
    }
}

