/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TriggerPathAndMethodMustExistInApiRule
extends PreValidationRule {
    public TriggerPathAndMethodMustExistInApiRule() {
        super("Trigger PATH and METHOD must exist in the API specification.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (triggerDescriptors != null && !triggerDescriptors.isEmpty()) {
            return triggerDescriptors.stream().filter(x -> !TriggerPathAndMethodMustExistInApiRule.hasMatchingOperation(apiModel, x)).map(this::getValidationError).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean hasMatchingOperation(APIModel apiModel, TriggerDescriptor triggerDescriptor) {
        return ValidationUtils.getApiOperation(apiModel, triggerDescriptor) != null;
    }

    private ValidationError getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with PATH: " + triggerDescriptor.getPath() + " and METHOD: " + triggerDescriptor.getMethod().getName().toUpperCase() + " does not exist in the API spec";
        return new ValidationError(this, detail, triggerDescriptor.getLocation());
    }
}

