/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ValueProviderReferenceArgumentsExistsRule
extends PreValidationRule {
    private static final String ERROR_TEMPLATE = "Argument '%s' does not exist in the '%s' value provider declaration.";

    public ValueProviderReferenceArgumentsExistsRule() {
        super("When sending an argument to a value provider it must exist in the resolver declaration", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        for (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> reference : ValidationUtils.getValueProviderReferenceDescriptors(connectorDescriptor)) {
            List arguments = reference.getArguments();
            List parameters = reference.getDeclaration().getParameters();
            List errors = arguments.stream().filter(x -> parameters.stream().noneMatch(y -> y.getName().equalsIgnoreCase(x.getName()))).map(x -> this.getValidationError((ArgumentDescriptor)x, reference.getDeclaration())).collect(Collectors.toList());
            validationErrors.addAll(errors);
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ArgumentDescriptor argumentDescriptor, ResolverDeclarationDescriptor<?> declaration) {
        return new ValidationError(this, String.format(ERROR_TEMPLATE, argumentDescriptor.getName(), declaration.getName()), argumentDescriptor.getLocation());
    }
}

