/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;

import java.util.LinkedList;
import java.util.List;

public class GavVersionMustBeValidRule extends PreValidationRule {

  // R009
  public GavVersionMustBeValidRule() {
    super("Descriptor connectorGav's version must ve a valid Maven version",
          "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.",
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> validationErrors = new LinkedList<>();

    String version = connectorDescriptor.getConnectorGav().getVersion();
    String validVersion = XmlUtils.removeMavenVersionUnwantedCharacters(version);

    if (!version.equalsIgnoreCase(validVersion)) {
      validationErrors.add(getValidationError(connectorDescriptor));
    }

    return validationErrors;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
    final String detail =
        "Version '" +
            connectorDescriptor.getConnectorGav().getVersion()
            + "' is not a valid Maven version";

    return new ValidationError(this, detail, connectorDescriptor.getLocation());
  }
}
