/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;

import org.mule.weave.v2.parser.phase.CompilationException;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationDisplayNameExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationDisplayNameScriptMustCompileRule extends PreValidationRule {

  public OperationDisplayNameScriptMustCompileRule() {
    super("Operation display name expression is incorrect",
          String.format("The 'operationDisplayName' must be revisited (current bindings are '%s')",
                        Arrays.toString(OperationDisplayNameExpressionHandler.IMPLICIT_INPUTS)),
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
    List<ValidationError> result = new ArrayList<>();
    ExpressionDescriptor operationDisplayName = connectorDescriptor.getOperationDisplayName();
    if (operationDisplayName != null) {
      String expression = operationDisplayName.getExpression();
      try {
        new OperationDisplayNameExpressionHandler(expression);
      } catch (CompilationException e) {
        result.add(getValidationError(connectorDescriptor, e));
      }
    }

    return result;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
    String detail = "Expression in 'operationDisplayName' is not valid, error: \n" + e.getMessage();

    return new ValidationError(this, detail, connectorDescriptor.getOperationDisplayName().getLocation());
  }

}
