/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import static java.util.Arrays.stream;
import static java.util.stream.Collectors.joining;

public enum DescriptorMode {

  MINIMAL("minimal", true, true, true, true, true, false, false, false, true, true), VERBOSE("verbose", true, true, true, true,
      true, true, true, true, true, true);

  private final String name;
  private final boolean generateApiSpec;
  private final boolean generateApiName;
  private final boolean generateDescription;
  private final boolean generateConnectorGav;
  private final boolean generateBaseUri;
  private final boolean generateEndpoints;
  private final boolean generatePaginations;
  private final boolean generateSecurity;
  private final boolean generateDefaultPackage;
  private final boolean generateExtensionXml;

  DescriptorMode(String name, boolean generateApiSpec, boolean generateApiName, boolean generateDescription,
                 boolean generateConnectorGav, boolean generateBaseUri, boolean generateEndpoints, boolean generatePaginations,
                 boolean generateSecurity, boolean generateDefaultPackage, boolean generateExtensionXml) {
    this.name = name;
    this.generateApiSpec = generateApiSpec;
    this.generateBaseUri = generateBaseUri;
    this.generateApiName = generateApiName;
    this.generateDescription = generateDescription;
    this.generateConnectorGav = generateConnectorGav;
    this.generateEndpoints = generateEndpoints;
    this.generatePaginations = generatePaginations;
    this.generateSecurity = generateSecurity;
    this.generateDefaultPackage = generateDefaultPackage;
    this.generateExtensionXml = generateExtensionXml;
  }

  public String getName() {
    return this.name;
  }

  public boolean isGenerateApiSpec() {
    return generateApiSpec;
  }

  public boolean isGenerateApiName() {
    return generateApiName;
  }

  public boolean isGenerateDescription() {
    return generateDescription;
  }

  public boolean isGenerateConnectorGav() {
    return generateConnectorGav;
  }

  public boolean isGenerateBaseUri() {
    return generateBaseUri;
  }

  public boolean isGenerateEndpoints() {
    return generateEndpoints;
  }

  public boolean isGeneratePaginations() {
    return generatePaginations;
  }

  public boolean isGenerateSecurity() {
    return generateSecurity;
  }

  public boolean isGenerateDefaultPackage() {
    return generateDefaultPackage;
  }

  public boolean isGenerateExtensionXml() {
    return generateExtensionXml;
  }

  public static DescriptorMode getFromString(String descriptorMode) {
    return stream(values())
        .filter(x -> x.name().equalsIgnoreCase(descriptorMode))
        .findFirst()
        .orElseThrow(() -> getException(descriptorMode));
  }

  private static IllegalArgumentException getException(String descriptorMode) {
    final String allowedValues = stream(values()).map(Enum::name).collect(joining(", "));

    return new IllegalArgumentException("Descriptor mode '" + descriptorMode + "' is not supported. Allowed values are: "
        + allowedValues);
  }
}
