/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.List;

public abstract class ValidationRule {

  public enum Level {
    INFO, WARN, ERROR
  }

  protected final String description;
  protected final String explanation;
  protected final Level level;

  protected ValidationRule(String description, String explanation, Level level) {
    this.description = description;
    this.explanation = explanation;
    this.level = level;
  }

  public Level getLevel() {
    return level;
  }

  public String getDescription() {
    return description;
  }

  public String getExplanation() {
    return explanation;
  }

  public abstract List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel);

  public abstract List<ValidationError> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel,
                                                     ConnectorModel connectorModel);

}
