/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;

import org.mule.weave.v2.parser.phase.CompilationException;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationIdentifierScriptMustCompileRule extends PreValidationRule {

  public OperationIdentifierScriptMustCompileRule() {
    super("Operation identifier expression is incorrect",
          String.format("The 'operationIdentifier' must be revisited (available bindings are '%s')",
                        Arrays.toString(OperationIdentifierExpressionHandler.IMPLICIT_INPUTS)),
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
    List<ValidationError> result = new ArrayList<>();
    ExpressionDescriptor operationDisplayName = connectorDescriptor.getOperationIdentifier();
    if (operationDisplayName != null) {
      String expression = operationDisplayName.getExpression();
      try {
        new OperationIdentifierExpressionHandler(expression);
      } catch (CompilationException e) {
        result.add(getValidationError(connectorDescriptor, e));
      }
    }

    return result;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
    String detail = "Expression in 'operationIdentifier' is not valid, error: \n" + e.getMessage();

    return new ValidationError(this, detail, connectorDescriptor.getOperationIdentifier().getLocation());
  }

}
