/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils.getApiOperation;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;

import java.util.LinkedList;
import java.util.List;

public class TriggerUriParamsMustBeCompleteRule extends PreValidationRule {

  public TriggerUriParamsMustBeCompleteRule() {
    super("All URI parameters must be have a binding in the Trigger Descriptor.", EMPTY, ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
    List<ValidationError> results = new LinkedList<>();

    List<TriggerDescriptor> triggerDescriptors = connectorDescriptor.getTriggers();
    if (!triggerDescriptors.isEmpty()) {
      for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {

        APIOperationModel operationModel = getApiOperation(apiModel, triggerDescriptor);
        if (operationModel == null) {
          continue;
        }

        List<APIParameterModel> uriParamsModel = operationModel.getUriParamsModel();
        if (uriParamsModel.size() > triggerDescriptor.getParameterBindings().getUriParameters().size()) {
          results.add(getValidationError(triggerDescriptor));
        }
      }
    }

    return results;
  }

  private ValidationError getValidationError(TriggerDescriptor triggerDescriptor) {
    String detail =
        "Trigger with PATH: "
            + triggerDescriptor.getPath()
            + " and METHOD: "
            + triggerDescriptor.getMethod().getName().toUpperCase()
            + " is missing a binding for one of its URI parameters";

    return new ValidationError(this, detail, triggerDescriptor.getLocation());
  }
}
